/*****
 *
 * Xdo_gettimeofday RTAI implementation
 * Fix dead lock by DM <davor.munda@kopica-sp.si>
 * Update 2010.
 *
 *****/


#include <linux/module.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/time.h>

#include <asm/rtai.h>
#include <rtai_sched.h>
#include <rtai_wd.h>

MODULE_LICENSE("GPL");
MODULE_DESCRIPTION("RTAI do_gettimeofday implementation");
MODULE_AUTHOR("DM <davor.munda@kopica-sp.si>");


static struct timeval saved_tv;
static RTIME saved_rt;

void Xdo_gettimeofday(struct timeval *tv)
/** Prevent do_gettimeofday dead lock. **/
{
 unsigned try_seq;
 unsigned long flags;
 RTIME diff;
 long sec; 
 unsigned long ns;

    rtai_save_flags_and_cli(flags);

    try_seq = xtime_lock.sequence;
    if ( unlikely(try_seq & 1) ) { /* xtime is locked - calculate time */

        diff = rt_get_cpu_time_ns() - saved_rt;
        sec = ulldiv(diff, NSECS_PER_SEC, &ns);
        *tv = saved_tv;
        tv->tv_sec += sec;
        tv->tv_usec += (long)((ns + 500lu) / 1000lu);
        if ( tv->tv_usec >= 1000000lu ) {
            tv->tv_sec += 1;
            tv->tv_usec -= 1000000;
        }

    } else { /* refresh saved time */

        do_gettimeofday(&saved_tv);
        saved_rt = rt_get_cpu_time_ns();
        *tv = saved_tv;
    }

    rtai_restore_flags(flags);

    return;
}


int __my_init( void )
{
    do_gettimeofday(&saved_tv);
    saved_rt = rt_get_cpu_time_ns();

   return 0;
}

void __my_exit( void )
{
  return;
}

module_init(__my_init);
module_exit(__my_exit);

EXPORT_SYMBOL(Xdo_gettimeofday);
