/*
 *
 * Module: rtai_wd.h - Watchdog Interface Header by DM 
 *                     <davor.munda@kopica-sp.si>.
 *
 * Version: 1.1.0 - 2003/06/06 : DM - Basic version
 *          1.2.0 - 2004/10/07 : DM - Added max task spent uP time
 *
 */


#ifndef _RTAI_WD_DEF_
 #define _RTAI_WD_DEF_

#ifdef __cplusplus
 extern "C" {
#endif


#define  WD_CMD_FIFO   0  /* command fifo /dev/rtf0 */
#define  WD_DATA_FIFO  1  /* data fifo /dev/rtf1 */

#define  WD_CMD_FIFO_NAME   "/dev/rtf0"
#define  WD_DATA_FIFO_NAME  "/dev/rtf1"


typedef enum {
    WD_RESET_DATA_CMD    = 0,   /* reset RT FIFO */
    WD_GET_DATA_CMD      = 1,   /* get tasks data */
    WD_GET_RTSTATUS_CMD  = 2,   /* get RT status */
    WD_RESET_UPTIMES_CMD = 4    /* reset all uP times to 0 */
} WD_CMD_ENUM;

typedef struct {
    WD_CMD_ENUM  cmd;
} WD_CMD;


typedef enum {
    WD_READSTATUS_ERR = -1, /* RT FIFO error */
    WD_RUN_STATUS     =  1, /* RT tasks run */
    WD_SUSPEND_STATUS =  2  /* RT tasks suspended */
} WD_RTSTATUS_ENUM;


typedef struct {
    long  sec; /* seconds of processor time */
    long  ns;  /* nano seconds processor time remainder */
} WD_UP_TIME;

typedef struct {
    char           name[8];  /* task name */
    unsigned long  handle;   /* task handle */
    WD_UP_TIME     uptime;   /* processor time summa */
    unsigned long  max_uptime; /* man spent processor time */
} WD_TASK_DATA;


#define  WD_SHIFTNO_MAX_RTTASKS  5

#define  WD_RTTASK_MAX_NO   (1<<WD_SHIFTNO_MAX_RTTASKS)  /* max watched RT tasks = 30 (+Linux +WD) */

#define  WD_CMD_FIFO_SIZE   (sizeof(WD_CMD)<<1)       /* 2 commands */
#define  WD_DATA_FIFO_SIZE  (sizeof(WD_TASK_DATA)<<(WD_SHIFTNO_MAX_RTTASKS+1)) /* 64 records - must be greather than WD_RTTASK_MAX_NO */

#define  WD_LINUX_TASKNAME     "Linux\0\0\0"     /* Idle (Linux) task */
#define  WD_SELF_TASKNAME      "WD\0\0\0\0\0\0"  /* WD task */
#define  WD_OTHER_TASKNAME     "RTtask\0\0"      /* other RT tasks */
#define  WD_OVERFLOW_TASKNAME  "OverFl\0\0"      /* to many RT tasks */

#define  WD_LAST_RECORDNAME    "TheEnd\0\0"      /* end of data */
#define  WD_RT_STATUSNAME      "Status\0\0"      /* status info */


#ifdef __cplusplus
 }
#endif

#endif  /* _RTAI_WD_DEF_ */

