
#include <iostream.h>
#include <stdio.h>

#include "wd.h"


int main( int argc, char *argv[] )
{
 WD_TASK_DATA   dataBuff[WD_RTTASK_MAX_NO];
 WD_READ_DATA_RESULT_ENUM  res;
 int            no_rt_tasks = 0;
 int            i;
 long           allSec = 0, allNs = 0;
 WD_RTSTATUS_ENUM  status;
 wd_class       wd;


// Read RT tasks data
	if ( (res = wd.read_data(no_rt_tasks, dataBuff[0], sizeof(dataBuff)/sizeof(dataBuff[0]))) == WD_READ_DATA_OK ) {
	    cout << "WD Read Data O.K.:" << endl;
		cout << "------------------" << endl;
		for ( i = 0; i < no_rt_tasks; ++i ) {
		    printf("Task %02d : Name: %8s, Handle: 0x%x, Run: %10ldsec, %9ldns\n",
			       i, dataBuff[i].name, (int)dataBuff[i].handle, dataBuff[i].uptime.sec, dataBuff[i].uptime.ns);
			printf(" => Handle: 0x%x, MaxTime: %11luns\n", (int)dataBuff[i].handle, dataBuff[i].max_uptime);
		    allSec += dataBuff[i].uptime.sec;
			if ( (allNs += dataBuff[i].uptime.ns) >= 1000000000 ) {
			    ++allSec;
				allNs -= 1000000000;
			}
		}
		cout << "------------------" << endl;
		cout << "All WD Time is " << allSec << "sec, " << allNs << "ns" << endl;
	}
	else
	    cout << "WD Read Data Error: " << res << "." << endl;

// Read RT tasks status
    status = wd.read_rtstatus();
	switch ( status ) {
	    case WD_READSTATUS_ERR :
		    cout << "Error reading RT status info" << endl;
            break;
		case WD_RUN_STATUS :
		    cout << "RT tasks are running" << endl;
            break;
        case WD_SUSPEND_STATUS :
		    cout << "RT tasks are suspended" << endl;
            break;
	    default :
		    cout << "Unknown status result" << endl;
            break;
	}

// Reset RT tasks uP times
    if ( argc > 1
	     &&
	     !memcmp(argv[1], "reset", strlen(argv[1])) ) {
	    if ( wd.reset_uptimes() == WD_RESETTIME_OK )
		    cout << "All tasks times are reseted" << endl;
        else
		    cout << "Reset uP times Error" << endl;
	}


   return 0;
}

