/***************************************************************************
  PROJECT    : RTAI-Watchdog / wd.h
  DESCRIPTION: WD user API
  AUTHOR     : DM <davor.munda@kopica-sp.si>

  DM         2003/06/07    1.1.0    Basic version
 ***************************************************************************/
#ifndef _WD_H_DEF_
#define _WD_H_DEF_


#include <rtai_wd.h>	    // WD common header


// Read RT tasks data results
typedef enum {
    WD_READ_DATA_ERR  = -1,  // error
    WD_READ_DATA_OK   =  0,  // data OK
    WD_READ_DATA_MORE =  1   // we have more data in the rtf - increase buffer
} WD_READ_DATA_RESULT_ENUM;

// Reset uP times for tasks results
typedef enum {
    WD_RESETTIME_ERR  = -1,  // error
    WD_RESETTIME_OK   =  0   // OK
} WD_RESETTIME_RESULT_ENUM;


// WD Class
class wd_class {

  public:

    // constructor
    wd_class();

    // destructor
    ~wd_class();

    // read RT tasks data
    WD_READ_DATA_RESULT_ENUM read_data(
        int           &no_tasks,     // no RT tasks - data records
        WD_TASK_DATA  &data,         // data buffer
	const int     space_records  // no data records in buffer - data space
                                      );

    // reset uP times for all tasks to 0
    WD_RESETTIME_RESULT_ENUM reset_uptimes( void );

    // read RT tasks status
    WD_RTSTATUS_ENUM  read_rtstatus( void );


  private:

    int cmdFd, dataFd;	// rtfifo handels

    int  write_buffer(int fd, const void *buf, const int count);  // write
    int  read_buffer(int fd, void *buf, const int count);         // read


}; // wd_class


#endif  // _WD_H_DEF_
