/*
 *
 * Iskra SISTEMI (C) 2003  DM (davor.munda@kopica-sp.si)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.

 * Module: rtai_common.h - RTAI  LXRT / Kernel  Common Header.
 *
 * Version: 1.1.0 - 2003/04/01 : Basic version - DM
 * Version: 1.2.0 - 2003/04/14 : Additional wrap defines - DM
 * Version: 2.1.0 - 2003/05/06 : Don't include all LXRT headers in user space, because CPP compiler fails - DM
 *
 */

#ifndef _RTAI_COMMON_DEF_
 #define _RTAI_COMMON_DEF_


#ifdef WIN32
 #include <os_api.h>
#endif
#ifdef OS_WIN32
 #include <process.h>
 #ifndef __KERNEL__
 #define __KERNEL__
#endif
/********** WINDOWS **********/
#define pthread_t   UINT
#define RT_TASK     TOs_Hnd
#define MBX         UINT
#define pthread_mutex_t UINT
typedef INT64 RTIME;
#endif /* OS_WIN32 */


#ifndef  __KERNEL__
/*****
 * UserSpace - LXRT
 *****/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <pthread.h>
#include <signal.h>
#include <errno.h>

#include <sys/types.h>
#include <sys/mman.h>
#include <sys/stat.h>

#include <rtai_lxrt_user.h>

#define KEEP_STATIC_INLINE

#define BCK_USE_FPU  1    /* Backgroud Linux will use FPU */
#define  printx  printf


#else
/*****
 * Kernel - HardRT
 *****/

#ifndef OS_WIN32

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/version.h>
#include <linux/slab.h>

#include <rtai.h>
#include <rtai_sched.h>
#include <rtai_fifos.h>

#include <../posix/include/rtai_pthread.h>

MODULE_LICENSE("GPL");

#endif 

#define BCK_USE_FPU  0
#ifndef OS_WIN32
 #define  printx  rt_printk
#else
 #define  printx  printf
#endif

#ifndef _GOT_DEF_
#define _GOT_DEF_
int _GLOBAL_OFFSET_TABLE_;  /* We need this to avoid unresolved symbol */
#endif

#endif


#endif /* _RTAI_COMMON_DEF_ */

