/*
 *
 * Iskra SISTEMI (C) 2003  DM (davor.munda@kopica-sp.si)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * Module: rtx.hpp - RTX CPP Header (UserSpace).
 *
 * Version: 2.1.0 - 2003/05/06 : Basic version - DM
 *
 */


#ifndef _RTX_HPP_DEF_
 #define _RTX_HPP_DEF_

#ifdef __cplusplus


typedef int (*rtx_initF)(void);
typedef void (*rtx_cleanF)(void);


class  thread_run_class {

  public:

    thread_run_class( rtx_initF, rtx_cleanF );
    ~thread_run_class( void );
};


#define  RTX_ENTRY(entry)   static void cleanup_module(void);        \
                            static thread_run_class * entry##_task = \
                                new thread_run_class(entry, cleanup_module);


#endif  // __cplusplus

#endif  // _RTX_HPP_DEF_
