/*
 *
 * Iskra SISTEMI (C) 2003  DM (davor.munda@kopica-sp.si)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * Module: rtx_types.h - RTX Interface Types.
 *
 * Version: 1.1.0 - 2003/04/01 : Basic version - DM
 * Version: 1.2.0 - 2003/04/14 : The same API for LXRT and kernel Hard RT, added alloc routines - DM
 * Version: 2.1.0 - 2003/05/06 : Separate RTX modules (cpp class usage in LXRT UserSpace) - DM
 * Version: 2.2.0 - 2003/05/20 : Set max priority one level lower (the highest priority is reserved) - DM
 * Version: 2.3.0 - 2003/06/09 : Include rtai_wd.h Watchdog header and use Watchdog limits - DM
 *
 */


#ifndef _RTX_TYPES_DEF_
 #define _RTX_TYPES_DEF_

#ifdef __cplusplus
 extern "C" {
#endif


#include <rtai_common.h>
#include <rtai_wd.h>



#define  RTX_MAX_PRIORITY_PTHREAD   98           /* POSIX Threads max priority (99-1, keep 99 in reserve) */
#define  RTX_MIN_PRIORITY_PTHREAD    1           /* POSIX Threads min priority */

#define  RTX_MAX_PRIORITY_RTAI       1           /* RTAI Task max priority (0+1, keep 0 in reserve) */
#define  RTX_MIN_PRIORITY_RTAI       0x3fffFfff  /* RTAI Task min priority */

#define  RTX_PRIORITY_PERIODIC_NORMAL     (RTX_MIN_PRIORITY_RTAI - 0xffff)   /* normal priority for periodic tasks */
#define  RTX_PRIORITY_ONESHOT_NORMAL      (RTX_MIN_PRIORITY_RTAI - 0x00ff)   /* normal priority for oneshot tasks */


/** Result **/
typedef enum {
    RTX_FAILURE = -1,
    RTX_SUCCESS = 0
} RTX_RESULT;

/** Task mode **/
typedef enum {
    RTX_TASK_PERIODIC  = 1,
    RTX_TASK_ONESHOT   = 2
} rtx_task_mode;

/** Task priority **/
typedef enum {
    RTX_TPRIOR_PERIODIC_NORMAL = RTX_PRIORITY_PERIODIC_NORMAL,  /* normal periodic priority */
    RTX_TPRIOR_ONESHOT_NORMAL  = RTX_PRIORITY_ONESHOT_NORMAL,   /* normal oneshot priority - lower than periodic */
    RTX_TPRIOR_PERIODIC_TC     = RTX_MAX_PRIORITY_RTAI,         /* time critical periodic priority */
    RTX_TPRIOR_ONESHOT_TC      = RTX_MAX_PRIORITY_RTAI          /* time critical oneshot priority - the same as periodic */
} rtx_priority;


/** Handles **/
typedef  pthread_t        rtx_thread_handle, *rtx_thread_handlePtr;
typedef  RT_TASK          rtx_task_handle, *rtx_task_handlePtr;
typedef  MBX              rtx_mbx_handle, *rtx_mbx_handlePtr;
typedef  pthread_mutex_t  rtx_mutex_handle, *rtx_mutex_handlePtr;
typedef  int              rtx_fifo_devhandle, *rtx_fifo_devhandlePtr;



typedef  int           rtx_thread_priority;  /* thread priority */
typedef  int           rtx_task_arg;         /* task argument */
typedef  int           rtx_task_stacksize;   /* task stack size */
typedef  int           rtx_periodic_tickno;  /* no of periodic ticks */
typedef  RTIME         rtx_nano_time;        /* nano sec time */
typedef  RTIME         rtx_periodic_tick, *rtx_periodic_tickPtr; /* periodic task tick - nano sec */
typedef  int           rtx_mbx_msgLen;       /* MBX message size */
typedef  int           rtx_mbx_chMsgs;       /* MBX channel capacity in messages */
typedef  void*         rtx_mbx_msgPtr;       /* MBX message pointer */
typedef  unsigned int  rtx_fifo_id;          /* rtf fifo id - 0,...,63 */
typedef  int           rtx_fifo_size, *rtx_fifo_sizePtr;/* rtf fifo size */
typedef  void*         rtx_fifo_dataPtr;     /* rtf fifo data pointer */
typedef  int           rtx_fifo_dataSize;    /* rtf fifo data size */
typedef  int           rtx_fifo_okBytes;     /* rtf fifo put/get bytes no */
typedef  int           (*rtx_fifo_handler)(rtx_fifo_id); /* fifo handler callback */
typedef  void*         (*rtx_fifo_handler_lxrt_thread)(void*); /* lxrt fifo handler - not real fifo handler */
#ifdef OS_WIN32
typedef  void          (*rtx_fifo_handler_win32_thread)(void*); /* Win32 fifo handler - not real fifo handler */
#endif


#define  INVALID_RTF_HND   -1

#define RTX_RTF(rtfDevHnd,rtfSize)                     \
    rtx_fifo_devhandle   rtfDevHnd = INVALID_RTF_HND;  \
    rtx_fifo_size        rtfSize = 0;


#ifndef __KERNEL__  /* lxrt - user space */

#include <rtx.hpp>

#define  RTX_MAX_TASKS_NO   (WD_RTTASK_MAX_NO - 2 + 16)  /* max RTX tasks (-2 is because Idle (Linux) and WD tasks, +16 is because lxrt tasks) */

#define rtx_init  static int init_module(void); RTX_ENTRY(init_module); static int
#define rtx_cleanup  static void

#define  Xkill        killThread

typedef  void*  rt_entry;
typedef  void*  rt_arg;

typedef  void*  rtf_hentry;
typedef  void*  rtf_harg;

#define  rt_end   return( (void*)0);


#else /* kernel - hard RT */

#define  RTX_MAX_TASKS_NO   (WD_RTTASK_MAX_NO - 2)  /* max RTX tasks (-2 is because Idle (Linux) and WD tasks) */

typedef  int          rtx_init;
typedef  void         rtx_cleanup;

#define  Xkill        XKillTask

typedef  void  rt_entry;
typedef  int   rt_arg;

#ifndef OS_WIN32
typedef  int           rtf_hentry;
typedef  unsigned int  rtf_harg;
#else
typedef  void          rtf_hentry;
typedef  void*         rtf_harg;
#endif


#define  rt_end   return;

#endif /* end kernel defines and types */


/** Task entrypoint **/
typedef rt_entry (*rtai_task)(rt_arg);


#ifdef __cplusplus
 }
#endif

#endif  /* _RTX_TYPES_DEF_ */

