/*****
 *
 * Module: rtx_main.cpp - RTX main loop in UserSpace.
 *
 * Version: 2.2.1 - 2003/05/06 - DM
 *
 *****/


#include <iostream.h>

#include <rtx.h>

#include "rtx_main.hpp"


static rtx_task_handlePtr mytaskP;   /* master task pointer */
static int  endTask = 0;             /* end flag */

int  haveTimer = 0;           /* timer flag */

int cleanupCnt = 0;
rtx_cleanF  endTaskList[RTX_MAX_NO_TASKS];


thread_run_class::thread_run_class( rtx_initF  runTask, rtx_cleanF  stopTask )
{
    if ( cleanupCnt >= RTX_MAX_NO_TASKS ) {
        cout << " --- Too many RT Threads Error !" << endl;
    }
    else { // Run RT Thread
        if ( !haveTimer ) { /* We must have timer (until global timer is set) */
            stop_rt_timer();
            rt_set_oneshot_mode();
            rt_preempt_always(1);
	        start_rt_timer(nano2count(0));
        }

        runTask();
	    endTaskList[cleanupCnt++] = stopTask;
    }
}

thread_run_class::~thread_run_class( void )
{
 //  No one call destructor
}



void endme( int dummy );
void endme( int dummy )
{
    if (dummy) {}

    endTask = 1;


   return; 
}


int main( void )
{
 unsigned long mytask_name = nam2num("RTX");
 int i;

 
    rt_linux_use_fpu(BCK_USE_FPU);

    signal(SIGINT, endme); /* Kbd IRQ ^C - starts endme */
    
    
    if ( !(mytaskP = rt_task_init(mytask_name, 1, 0, 0)) ) {
		printx(" -- Cannot Init Task %lu\n", mytask_name);
		exit(1);
	}

    rt_set_oneshot_mode();
    rt_preempt_always(1);  /* interruptable by higher priorities */

    start_rt_timer(nano2count(0));  /* Global RT Timer */

    haveTimer = 1;
    

    while ( !endTask ) { /* Loop till end rq */
        rt_sleep(nano2count(100000000)); /* 100 ms */
    }

       

    // Clenup tasks
	for ( i = 0; i < cleanupCnt; ++i ) {
        if ( endTaskList[i] ) {
            endTaskList[i]();
            endTaskList[i] = NULL;
        }
    }

    stop_rt_timer();         /* stop Timer */

    signal(SIGINT, SIG_DFL); /* default Kbd IRQ */


    rt_task_delete( mytaskP );  /* kill Master Task */


   return 0;
}


