/*
 *
 * Module: rtx-test2.c  Test RTX Interface.
 *
 */


#include <rtx.h>


/*** Tasks [RTX_TASK(handleSpace, handlePointer, taskEntry, tickSpace)] ***/
RTX_TASK(oneShotHnd, oneShotHndP, rt_oneShot, oneShotDummyTick, oneShotDummyTickP, oneShotThreadHnd, oneShotThreadHndP);


#define MY_RTTHREAD_STACK_SIZE   4096  /* bytes */



/**********
 * RT OneShot Task
 **********/

rt_entry  rt_oneShot( rt_arg arg )
{

   XREGISTER( oneShotHndP,
         RTX_TPRIOR_ONESHOT_NORMAL,
         MY_RTTHREAD_STACK_SIZE,
         RTX_TASK_ONESHOT,
         0,
         oneShotDummyTick );     /** Must call XRun to register with RT **/


 printx(" +++ OneShot task is running!\n");


    /* Main Loop */
    while ( 1 ) { /* Eternity */

       XDelayShort( 60000000000 );  /* 1 min */
       printx(" +++ OneShot still alive!\n");
    }


    rt_end;
}



rtx_init  init_module( void )
{
    /** Run RT Tasks **/

    if ( XRunTask( oneShotHndP,
                   RTX_TPRIOR_ONESHOT_NORMAL,
                   MY_RTTHREAD_STACK_SIZE,
                   RTX_TASK_ONESHOT,
                   1,
                   rt_oneShot,
                   oneShotThreadHndP,
                   0 ) != RTX_SUCCESS ) {
        printx(" -- OneShot RT Task Run Error\n");
		return 1;
    }


   return 0;
}


rtx_cleanup cleanup_module( void )
{       
    /* Ends RT Threads */

    if ( XKillTask( oneShotHndP, oneShotThreadHnd ) != RTX_SUCCESS )
        printx(" -- OneShot RT Task Kill Error %s\n", "oneShot");
    else
        printx(" + OneShot RT Task %s Ends\n", "oneShot");


   return;
}

