/*
 *
 * Module: rtx-test1.c  Test RTX Interface.
 *
 */


#include <rtx.h>


/*** Tasks [RTX_TASK(handleSpace, handlePointer, taskEntry, tickSpace, threadHandle)] ***/
RTX_TASK(funTCHnd, funTCHndP, rt_funTC, funTCTick, funTCTickP, funTCThreadHnd, funTCThreadHndP);
RTX_TASK(funNormalHnd, funNormalHndP, rt_funNormal, funNormalTick, funNormalTickP, funNormalThreadHnd, funNormalThreadHndP);


/*** MBXs [RTX_MBX(handleSpace, handlePointer)] ***/
RTX_MBX(mbxCh1, mbxCh1P);
RTX_MBX(mbxCh2, mbxCh2P);


/*** RTFs [RTX_RTF(rtfDeviceHandle, rtfSizeSpace)] ***/
RTX_RTF(rtf2_devHnd, rtf2_Size);
RTX_RTF(rtf3_devHnd, rtf3_Size);

/*** RTF handles [RTX_RTFHANDLE(handlePointer, tickSpace, handleEntry, threadHandle)] ***/
RTX_RTFHANDLER(rtf2_HndP, rtf2_Tick, rtf2_handler, rtf2_threadHnd);


/*** MuteXes ***/
rtx_mutex_handle     mx1Hnd;
rtx_mutex_handlePtr  mx1HndP = &mx1Hnd;


#define MY_TICK_PERIOD        1000000  /* ns tick = 1 ms */
#define MY_RTTHREAD_STACK_SIZE   4096  /* bytes */


int  waitForRTFUser = 1;



/**********
 * RT TC Task
 **********/

rt_entry rt_funTC( rt_arg arg )
{
 int   counter = -1;
 int   msg1 = 0;
 char  msg2[8];


   XREGISTER( funTCHndP,
         RTX_TPRIOR_PERIODIC_TC,
         MY_RTTHREAD_STACK_SIZE,
         RTX_TASK_PERIODIC,
         MY_TICK_PERIOD,
         funTCTick );     /** Must call XREGISTER to register with RT **/


 printx(" +++ TC periodic task is running!\n");


 XDelay( 1000, funTCTickP ); /* 1000 ticks to establish channels */
 if ( XWaitMBX( mbxCh1P, &msg1, sizeof(msg1), 500000 ) == RTX_SUCCESS )
    printx(" + funTC Wait1 msg1=%d\n", msg1);
 if ( XWaitMBX( mbxCh1P, &msg1, sizeof(msg1), 500000 ) == RTX_SUCCESS )
    printx(" + funTC Wait11 msg1=%d\n", msg1);
 if ( XReadMBX( mbxCh1P, &msg1, sizeof(msg1), 500000, NULL ) == RTX_SUCCESS )
    printx(" + funTC Read1 msg1=%d\n", msg1);
 if ( XWaitMBX( mbxCh2P, &msg2[0], 8, 500000 ) == RTX_SUCCESS )
    printx(" + funTC Wait2 msg2=%s\n", msg2);
 if ( XWaitMBX( mbxCh2P, &msg2[0], 8, 500000 ) == RTX_SUCCESS )
    printx(" + funTC Wait22 msg2=%s\n", msg2);
 if ( XReadMBX( mbxCh2P, &msg2[0], 8, 500000, funNormalHndP ) == RTX_SUCCESS )
    printx(" + funTC Read2 msg2=%s\n", msg2);


 XDelay( 5000, funTCTickP ); /* wait 5 sec */
 printx(" + Lock TC and wait NormalTask to unlock. Tick=%Ld\n", rt_get_time());
 XLockSection( mx1HndP );
 XDelay( 1, funTCTickP );
 printx(" + TC Unlocked. Tick=%Ld\n", rt_get_time());
 XUnlockSection( mx1HndP );

	/* Main Loop */
    while ( 1 ) { /* Eternity */

        if ( !(++counter % 60000) ) { /* Output every 60000 ticks */
            printx(" ++ Still alive funTC, counter=%d msTime=%lu\n", counter, (unsigned long)(rt_get_time_ns()/1000000LL));
        }

       XDelay( 1, funTCTickP );
    }


    rt_end;
}



/**********
 * RT Normal Task
 **********/

rt_entry rt_funNormal( rt_arg arg )
{
 rtx_task_handlePtr  id;
 int     msg1 = 5;
 char    msg2[8] = { '_', 'H', 'a', 'l', 'l', 'o', '!', '\0' };
 int     data;
 char    *spacePtr;


   XREGISTER( funNormalHndP,
         RTX_TPRIOR_PERIODIC_NORMAL,
         MY_RTTHREAD_STACK_SIZE,
         RTX_TASK_PERIODIC,
         10 * MY_TICK_PERIOD,
         funNormalTick );       /** Must call XREGISTER to register with RT **/


 printx(" +++ Normal periodic task is running!\n");


 /* RTX usage sample */

 id = XGetId();
 printx(" ++ funNormal id=%p\n", id);
 XCPri( XGetId(), RTX_TPRIOR_PERIODIC_NORMAL);
 printx(" + Time before delay funNormal ms=%lu\n", (unsigned long)(rt_get_time_ns()/1000000LL));
 XDelay( 5, funNormalTickP );
 printx(" + Time after delay 5 ticks funNormal ms=%lu\n", (unsigned long)(rt_get_time_ns()/1000000LL));
 printx(" + Time before delayShort funNormal ms=%lu\n", (unsigned long)(rt_get_time_ns()/1000000LL));
 XDelayShort( 5000000 );
 printx(" + Time after delayShort 5,000,000 nanosecs funNormal ms=%lu\n", (unsigned long)(rt_get_time_ns()/1000000LL));
 printx(" ++ Suspend funTC\n");

 XStop( funTCHndP );
 XDelayShort( 500000 );
 printx(" ++ Resume funTC\n");
 XResume( funTCHndP );

 printx(" + funNormal tick=%lu nsec\n", (unsigned long)XGetTickInterv( funNormalTickP ));
 XSetTickInterv( funNormalTickP, 15000000 );
 printx(" + funNormal tick=%lu nsec\n", (unsigned long)XGetTickInterv( funNormalTickP ));
 printx(" + funNormal  1000000 ns = %d ticksTrunc and %d ticksRoundUp\n", XGetNoTicksTrunc( 1000000, funNormalTickP ), XGetNoTicksRoundUp( 1000000, funNormalTickP ) );
 printx(" + funNormal 30000000 ns = %d ticksTrunc and %d ticksRoundUp\n", XGetNoTicksTrunc( 30000000, funNormalTickP ), XGetNoTicksRoundUp( 30000000, funNormalTickP ) );

 XSendMBX( mbxCh1P, &msg1, sizeof(msg1), 0, 0, NULL );
 XSendMBX( mbxCh2P, &msg2[0], 8, 0, 1000000000 /*1 sec*/, funTCHndP );

 printx(" +++ Critical Section - Start\n");
 XUnlockSection( mx1HndP );
 XUnlockSection( mx1HndP );
 XLockSection( mx1HndP );
 if ( XTryLockSection( mx1HndP ) == RTX_FAILURE )
    printx(" + Locked\n");
 XUnlockSection( mx1HndP );
 if ( XTryLockSection( mx1HndP ) == RTX_FAILURE )
    printx(" + Locked\n");
 XUnlockSection( mx1HndP );
 printx(" +++ Critical Section - End\n");

 if ( (spacePtr = (char *)XMAlloc(16)) == NULL )
    printx(" -- Out of memory\n");
 else {
    memcpy(spacePtr, "My string\0", 10);
    printx(" + Allocated string=%s\n", spacePtr);
    XMFree(spacePtr);
 }

 XDelay( 1000, funNormalTickP ); /* wait 10 sec */
 XUnlockSection( mx1HndP );


 printx(" + Wait for rtf data\n");
 while ( waitForRTFUser )  XDelay( 1, funNormalTickP );
 data = 28;
 if ( XRtfPut( 3 /* rtf3 */, &data, sizeof(data), &rtf3_devHnd ) != sizeof(data) )
    printx(" -- rtf3 put data error\n");
 printx(" ++ Put data into rtf3\n");
 XDelay( 300, funNormalTickP );
 if ( XRtfReset( 3 /* rtf3 */, &rtf3_devHnd, &rtf3_Size) != RTX_SUCCESS )
    printx(" -- rtf3 reset error\n");
 printx(" ++ Reset rtf3\n");



    /** Main Loop **/
    while ( 1 ) { /* Eternity */

       XDelay( 1, funNormalTickP );
    }


    rt_end;
}



rtf_hentry  rtf2_handler( rtf_harg  arg )
{
 int  res;
 int  data;

/*** RTF handler register [RTF_HANDLER_BEGIN(handlePointer, tickSpace, fifoId)] ***/
 RTF_HANDLER_BEGIN(rtf2_HndP, rtf2_Tick, 2);    /** Must call to register handler with RTX system - eternity loop on LXRT **/

 
      if ( (res = XRtfGet( fifoId, &data, sizeof(data), &rtf2_devHnd )) == sizeof(data) ) {
      /* We have data here */
        printx(" + RT FIFO %u Data=%d\n", fifoId, data);

        waitForRTFUser = 0;
      }
      else
        if ( res != 0 )
            printx(" -- RT FIFO %u - get data error\n", fifoId);

            
 RTF_HANDLER_END(res, rtf2_Tick);  /** Must call to exit - sleep on LXRT **/
}



rtx_init  init_module( void )
{
    /** Get MuteXs **/

    if ( XGetFreeMuteX( mx1HndP ) != RTX_SUCCESS ) {
        printx(" -- MuteX %s GetFree Error\n", "1");
		return 1;
    }


    /** Create RT FIFOs **/

    if ( XRtfCreate( 2, sizeof(int) * 2, &rtf2_devHnd, &rtf2_Size ) != RTX_SUCCESS ) {
        printx(" -- RTFifo %d Create Error\n", 2);
        XReleaseMuteX( mx1HndP );
		return 1;
    }
    if ( XRtfCreateHandler( 2, rtf2_handler, &rtf2_threadHnd ) != RTX_SUCCESS ) {
        printx(" -- RTFifo %d Create Handler Error\n", 2);
        XRtfDestroy( 2, &rtf2_devHnd, &rtf2_Size, NULL );
        XReleaseMuteX( mx1HndP );
		return 1;
    }
    
    if ( XRtfCreate( 3, sizeof(int) * 1, &rtf3_devHnd, &rtf3_Size ) != RTX_SUCCESS ) {
        printx(" -- RTFifo %d Create Error\n", 3);
        XRtfDestroy( 2, &rtf2_devHnd, &rtf2_Size, &rtf2_threadHnd );
        XReleaseMuteX( mx1HndP );
		return 1;
    }

    
    /** Get MBXs **/

    if ( XGetFreeMBX( mbxCh1P, sizeof(int), 1 ) != RTX_SUCCESS ) {
        printx(" -- MBX %s GetFree Error\n", "ch1");
        XRtfDestroy( 2, &rtf2_devHnd, &rtf2_Size, &rtf2_threadHnd );
        XRtfDestroy( 3, &rtf3_devHnd, &rtf3_Size, NULL );
        XReleaseMuteX( mx1HndP );
		return 1;
    }
    if ( XGetFreeMBX( mbxCh2P, sizeof(char), 8 ) != RTX_SUCCESS ) {
        printx(" -- MBX %s GetFree Error\n", "ch2");
        XReleaseMBX( mbxCh1P );
        XRtfDestroy( 2, &rtf2_devHnd, &rtf2_Size, &rtf2_threadHnd );
        XRtfDestroy( 3, &rtf3_devHnd, &rtf3_Size, NULL );
        XReleaseMuteX( mx1HndP );
		return 1;
    }


    /** Run RT Tasks **/

    if ( XRunTask(  funTCHndP,
                    RTX_TPRIOR_PERIODIC_TC,
                    MY_RTTHREAD_STACK_SIZE,
                    RTX_TASK_PERIODIC,
                    MY_TICK_PERIOD,
                    rt_funTC,
                    funTCThreadHndP,
                    0 ) != RTX_SUCCESS ) {
        printx(" -- RT Task %s Run Error\n", "funTC");
        XReleaseMBX( mbxCh1P );
        XRtfDestroy( 2, &rtf2_devHnd, &rtf2_Size, &rtf2_threadHnd );
        XRtfDestroy( 3, &rtf3_devHnd, &rtf3_Size, NULL );
        XReleaseMuteX( mx1HndP );
		return 1;
    }

    if ( XRunTask(  funNormalHndP,
                    RTX_TPRIOR_PERIODIC_NORMAL,
                    MY_RTTHREAD_STACK_SIZE,
                    RTX_TASK_PERIODIC,
                    10 * MY_TICK_PERIOD,
                    rt_funNormal,
                    funNormalThreadHndP,
                    0 ) != RTX_SUCCESS ) {
        printx(" -- RT Task %s Run Error\n", "funNormal");
        XKillTask( funTCHndP, funTCThreadHnd );
        XReleaseMBX( mbxCh1P );
        XReleaseMBX( mbxCh2P );
        XRtfDestroy( 2, &rtf2_devHnd, &rtf2_Size, &rtf2_threadHnd );
        XRtfDestroy( 3, &rtf3_devHnd, &rtf3_Size, NULL );
        XReleaseMuteX( mx1HndP );
		return 1;
    }


   return 0;
}


rtx_cleanup cleanup_module( void )
{
    /* Ends RT Threads */

    if ( XKillTask( funTCHndP, funTCThreadHnd ) != RTX_SUCCESS )
        printx(" -- RT Task Kill Error %s\n", "funTC");
    else
        printx(" + RT Task %s Ends\n", "funTC");

    if ( XKillTask( funNormalHndP, funNormalThreadHnd ) != RTX_SUCCESS )
        printx(" -- RT Task Kill Error %s\n", "funNormal");
    else
        printx(" + RT Task %s Ends\n", "funNormal");

                
    /* Release MBXs */

    if ( XReleaseMBX( mbxCh1P ) != RTX_SUCCESS ) {
        printx(" -- MBX %s Release Error\n", "ch1");
    }
    if ( XReleaseMBX( mbxCh2P ) != RTX_SUCCESS ) {
        printx(" -- MBX %s Release Error\n", "ch2");
    }


    /* Destroy RT FIFOs */
    XRtfDestroy( 2, &rtf2_devHnd, &rtf2_Size, &rtf2_threadHnd );
    XRtfDestroy( 3, &rtf3_devHnd, &rtf3_Size, NULL );

    
    /* Release MuteXs */

    if ( XReleaseMuteX( mx1HndP ) != RTX_SUCCESS ) {
        printx(" -- MuteX %s Release Error\n", "1");
    }
                                

   return;
}

